#include <cstdlib>
#include <iostream>

#include "util.h"
#include "VPC.h"

void message()
{
    std::cout<<"We assume that a leave-one-out cross validation method is used."<<std::endl;
    std::cout<<"Thus each frame is tested exactly once."<<std::endl;
    std::cout<<"We assume all homes are used"<<std::endl;
    std::cout<<"But you can choose a subset of the semantic room categories."<<std::endl;
    std::cout<<"Test output are stored in the following format:"<<std::endl;
    std::cout<<"---The first line prints whether a category is used,"<<std::endl;
    std::cout<<"---e.g. if only bedroom and bathroom are used,"<<std::endl;
    std::cout<<"---then 1st line should be  \"0 1 1 0 0 ...\""<<std::endl;
    std::cout<<"---from the 2nd line to the last line, each line print the prediction of a frame"<<std::endl;
    std::cout<<"---(i.e. a number between [0..VPC_numCategory-1])"<<std::endl;
    std::cout<<"---These predictions must be in the same order as those"<<std::endl;
    std::cout<<"---produced by the VPC_Traverse function."<<std::endl;
    std::cout<<"---Please refer to the file VPC_IO.cpp for details."<<std::endl;
    std::cout<<"NOTE: I do not check the validity of this file."<<std::endl;
    std::cout<<"---you need to make sure the format is correct."<<std::endl;
    std::cout<<"Hint: use VPC_Traverse to produce your output file to make sure a right format."<<std::endl;
    std::cout<<"Output: confusion matrices, an overall accuracy, and per-category accuracies."<<std::endl;
    std::cout<<"-----------------------------------------------------"<<std::endl;
}

void error()
{
    std::cout<<"Usage: ./evaluate file"<<std::endl;
    std::cout<<"where 'file' contains output of your method."<<std::endl;
    std::cout<<"-----------------------------------------------------"<<std::endl;
    message();
}

int main(int argc,char* argv[])
{
    if(argc!=2)
    {
        error();
        exit(-1);
    }

    if(FileExists(argv[1])==false)
    {
        std::cout<<"ERROR: The file "<<argv[1]<<" does not exists."<<std::endl;
        std::cout<<"-----------------------------------------------------"<<std::endl;
        error();
        exit(-1);
    }

    message();
    VPC_Evaludate_Single_Frame(argv[1]);
}